local assets =
{
    Asset("ANIM", "anim/frog.zip"),
    Asset("SOUND", "sound/frog.fsb"),
}

local prefabs =
{
}

local brain = require "brains/frogbrain"

local function retargetfn(inst)
    if not inst.components.health:IsDead() and not inst.components.sleeper:IsAsleep() then
        return FindEntity(inst, TUNING.FROG_TARGET_DIST, function(guy) 
            if not guy.components.health:IsDead() then
                return guy.components.inventory ~= nil
            end
        end,
        {"_combat","_health"} -- see entityreplica.lua
        )
    end
end

local function ShouldSleep(inst)
    return false -- frogs either go to their home, or just sit on the ground.
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30, function(dude) return dude:HasTag("frog") and not dude.components.health:IsDead() end, 5)
end

local function OnHitOther(inst, other, damage)
    inst.components.thief:StealItem(other)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
    inst.entity:AddNetwork()

    MakeCharacterPhysics(inst, 1, .3)

    inst.DynamicShadow:SetSize(1.5, .75)
    inst.Transform:SetFourFaced()
    inst.AnimState:SetBank("wilson")
    local names = {"wilson","wendy","wes","wickerbottom","willow","wolfgang","wx78"}--设置名字
    local buildname = names[math.random(#names)]--设置build用以上随机的
	inst.AnimState:SetBuild(buildname)
	
    inst.AnimState:PlayAnimation("idle")
local hats = {"hat_bee","hat_beefalo","hat_bush","hat_earmuffs","hat_feather","hat_flower","hat_football","hat_miner","hat_ruins","hat_slurper","hat_slurtle","hat_spider","hat_straw","hat_top","hat_walrus","hat_winter","hat_rain","hat_watermelon","hat_ice","hat_catcoon","hat_wathgrithr"}
    local hat = hats[math.random(#hats)]--和上面的手法一样
    inst.AnimState:OverrideSymbol("swap_hat", hat, "swap_hat")--戴帽子的代码
    local armors = {"armor_grass","armor_marble","armor_onemanband","armor_ruins","armor_sanity","armor_slurper","armor_slurtleshell","armor_sweatervest","armor_trunkvest_summer","armor_trunkvest_winter","armor_wood","torso_rain"}
    local armor = armors[math.random(#armors)]--和上面手法一样，随机盔甲。。。
    inst.AnimState:OverrideSymbol("swap_body", armor, "swap_body")--穿盔甲的代码
	local weapons = {"swap_axe","swap_batbat","swap_cane","swap_diviningrod","swap_ruins_bat","swap_fishingrod","swap_goldenaxe","swap_goldenpickaxe","swap_goldenshovel","swap_ham_bat","swap_hammer","swap_lucy_axe","swap_nightmaresword","swap_pickaxe","swap_pitchfork","swap_ruins_bat","swap_shovel","swap_spear","swap_spike","swap_umbrella","swap_spear_wathgrithr","swap_parasol"}
    local weapon = weapons[math.random(#weapons)]
	inst.AnimState:OverrideSymbol("swap_object", weapon, weapon)
	inst.AnimState:Show("HAT")
    inst.AnimState:Show("HAT_HAIR")
    inst.AnimState:Hide("HAIR_NOHAT")
    inst.AnimState:Hide("HAIR")
    inst.AnimState:Hide("ARM_carry")
	inst.AnimState:Show("ARM_carry")
    inst.AnimState:Hide("ARM_normal")
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
        local minimap = inst.entity:AddMiniMapEntity()--设置npc在地图上的标志
    minimap:SetIcon( "lighter.png" )--标志用灯的贴图
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 8

    inst:SetStateGraph("SGshadowwaxwell")

    inst:SetBrain(brain)

    inst:AddComponent("sleeper")
    inst.components.sleeper:SetSleepTest(ShouldSleep)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(200)

  inst:AddComponent("combat")
  inst.components.combat:SetDefaultDamage(15)
    inst.components.combat:SetAttackPeriod(1)
    inst.components.combat:SetRetargetFunction(3, function(inst)
        if not inst.components.health:IsDead() then
            return FindEntity(inst, 20, function(guy)
                if guy.components.combat and guy.components.health and not guy.components.health:IsDead() then
                   return guy.components.combat.target == inst or inst.components.combat.target == guy or guy:HasTag("monster")
                end
            end )
        end
    end )
	    inst.components.combat:SetKeepTargetFunction(function(inst, target) return target and target:IsValid() end )
    inst:ListenForEvent("attacked", function(inst, data)
        inst.components.combat:SetTarget(data.attacker)
        inst.components.combat:ShareTarget(data.attacker, 30, function(dude) return dude:HasTag("npcs") and not dude.components.health:IsDead() end, 5)
    end )
    inst:AddComponent("thief")

    MakeTinyFreezableCharacter(inst, "frogsack")

    MakeHauntablePanic(inst)

    inst:AddComponent("lootdropper")

    inst:AddComponent("knownlocations")
    inst:AddComponent("inspectable")

    inst:ListenForEvent("attacked", OnAttacked)
 
  inst:AddComponent("talker")
      inst:DoPeriodicTask(math.random(30,60), function()--随机台词
        local words = {"好天气~","艾瑞巴蒂嗨起来","我爱这里，也包括这里的妹子！","非常感谢~嗝~","鸢一一曹劳资的意大利炮呢","饿的我都要吃便便了","热成狗了","冻成狗了","你好啊baby","赛有那拉","对不起你是个好人","早上应该多睡会","下午应该多玩会","你也修仙啊","回家回家","我想去搞个大新闻，啊，不，是打猎","我缺钱了，我应该挖点宝石去","哎，骚年，你听说过安利么","我的钻头，是突破天际的钻头啊","我要去贴吧钓鱼。。。","我想念诗。。gou。。。","我想打架。。。。喂别这样看我，我是好混混","我需要补魔。。。","我需要好♂男人","我是拉拉人","我抽到ssr了！","我想要造个。。咳咳，交个朋友~"}
        local word = words[math.random(#words)]
        inst.components.talker:Say(word, 4, false)
    end)
    return inst
end

return Prefab("villager", fn, assets, prefabs)
